

Este fichero excel es de elaboracin propia, y se construye en base a los datos entregados por la "Encuesta de estructura salarial ao 2006". 
Las observaciones tomadas corresponden a las personas cuyo nivel de educacin es "licenciados, ingenieros superiores y doctores". 
Estos datos se utilizan en los cursos de econometra para analizar cules son los principales factores que determinan las diferencias salariales de los trabajadores en Espaa. 
En la siguiente web esta la informacin de esta encuesta https://www.ine.es/dyngs/INEbase/es/operacion.htm?c=Estadistica_C&cid=1254736177025&menu=resultados&secc=1254736195110&idp=1254735976596

En nuestro fichero las variables utilizadas son: Salario, logaritmo del salario, antiguerdad, antiguedad al cuadrado, sexo, edad, nmero de horas trabajadas en el mes de octubre de 2006, nacionalidad, control de la empresa, 
tipo de jornada laboral, tipo de duracin del contrato y responsabilidad.  

Logaritmo del salario, y antiguedad al cuadrado son variables que se utilizan siguiendo la teora de las ecuaciones de Mincer para analizar la estructura de los salarios.;

libname pm"F:\tarea sas\pm";

proc import out=pm.encuestaine
datafile ="F:\tarea sas\varpm.xlsx"
dbms=xlsx replace;
getnames=yes;
run;

proc print data=pm.encuestaine (obs=10);
run;


proc format library = pm;
value sexo 1="hombre" 6="mujer";
value edad 1="menor de 19 aos" 2="entre 20 a 29 aos" 3="entre 30 y 39 aos" 4="entre 40 y 49 aos" 5="entre 50 y 59 aos" 6="ms de 59 aos";
value nac 1="espaa" 2="no espaa";
value control 1="pblico" 2="privado";
value tipoj 1="completa" 6="parcial";
value tipoc 1="indefinido" 2="determinado";
value respon 1="si" 6="no";
run;

options fmtsearch = (pm);

data pm.encuestaine2;
set pm.encuestaine;
label nht="horas trabajadas" sal = "salario" lsal = "logaritmo del salario" anti= "antiguedad en la empresa" anti2="antiguedad al cuadrado" nac= "nacionalidad" control="empresa estatal o privada" tipoj="tipo jornada" tipoc="tipo contrato" respon="responsabilidad";
format sexo sexo. ;
format edad edad.;
format nac nac. ;
format control control.;
format tipoj tipoj. ;
format tipoc tipoc.;
format respon respon. ;
run;

ods rtf file='F:\tarea sas\tareacom.rtf';
proc contents data=pm.encuestaine2;
run;

proc means data=pm.encuestaine2 min mean q3 max;
run;

*Todo ha salido bien;

proc univariate data=pm.encuestaine2;
var sal anti nht;
histogram;
run;


proc tabulate data=pm.encuestaine2 ;
class edad sexo;
var sal nht;
tables edad*sexo,(n sal*mean nht*mean);
run;

proc iml;
reset print; 
proc corr data=pm.encuestaine2;
var sal anti nht;
run;
quit;
*aca veo que la diferencia entre hombre y mujeres y espaoles o no espaoles, no es significativa, explicado en informe;

PROC GCHART DATA = pm.encuestaine2;
VBAR  nac /DISCRETE TYPE = mean space = 4 mean
sumvar = lsal GROUP = sexo; 
RUN;

PROC GCHART DATA = pm.encuestaine2;
VBAR  nac /DISCRETE TYPE = mean space = 4 mean
sumvar = nht GROUP = sexo; 
RUN;
* aca planteo el modelo de regresion explicar el lsal. El modelo es muy sencillo, explicado en informe; 
proc reg data=pm.encuestaine2;
model lsal=sexo edad anti anti2 nht nac control tipoj tipoc respon;
run;
*macro sencilla, hace descriptivos e histogramas de 3 variables numericas;
%macro uni(bbdd,vnum1,vnum2,vnum3);
proc univariate data=&bbdd ;
var &vnum1 &vnum2 &vnum3;
histogram;
run;
%mend;

%uni(pm.encuestaine2,sal,anti,nht);

ods rtf close;

