/*Sesi 5 PROCEDIMIENTOS ESTADSTICOS*/

/*PROC FREQ

Permite construir tablas de frecuencias y de contingencia, 
contraste Chi2 de independencia, etc...
Se utiliza para variables categoricas o continuas agrupadas*/

/*SINTAXIS BASICA

PROC FREQ DATA = NOMARCHIVO OPCIONES1;
TABLE = VAR1 VAR2*VAR3 / OPCIONES2;
RUN;

OPCIONES1: Las ms utilizadas

NOPRINT: suprime cualquier impresin de tablas.
ORDER: FREQ/FORMATED/INTERNAL/... Categorias ordenadas por frecuencia/valor formateado/valor original de la variable. 
                                  Las numericas sin formatos aparecen en orden ascentende.

OPCIONES2:

CHISQ: para hacer el contraste Chi2 de independencia

Tambin se puede controlar la informacin que aparece en las casillas de las tablas de contingencia con las opciones:
NOROW
NOCOL
NOPERCENT
NOFREQ
EXPECTED
DEVIATION


MISSING: trata el grupo missing como un grupo ms y lo aade como una categora ms de la tabla
OUT: permite guardar las frecuencias calculadas

*/

proc freq data=sashelp.cars; 
table origin;
run;

proc freq data=sashelp.cars; 
table origin*type;
run;

proc freq data=sashelp.cars; 
table origin*type*DriveTrain;
run;

proc freq data=sashelp.cars; 
table origin*type/norow nocol nopercent; /*solo aparecer el recuento de casos*/
run;

/*Hacemos el test Chi2 de independencia, 
pero para ello la frecuencia esperada bajo hipt. de indep. ha de ser > 5*/

proc freq data=sashelp.cars; 
table origin*type /expected deviation chisq; /*recuento esperado bajo hipot indep y test chi cuadrado*/
run;
/* p-value<.0001 -> Rechazamos H0: origin y type son independientes. 
Por tanto, origin y type estan asociadas */

/* No imprimimos y los resultados los guardamos en la tabla temporal tablaf */
proc freq data=sashelp.cars noprint; 
table type / out=tablaf;
run;


/*PROC MEANS

Hace anlisis descriptivo para variables continuas

PROC MEANS DATA = Bdd / [OPCIONES];
VAR nomV1 nomV2.. ;
[CLASS/BY]; 
[OUTPUT OUT=BddOUTPUT]
RUN;

CLASS define subgrupos de individuos para realizar el analisis 
por separado (no requiere que el archivo est ordenado previamente)

BY define subgrupos de individuos para realizar el analisis 
por separado (requiere que el archivo est ordenado previamente)

OUTPUT OUT indica una base de datos que SAS crear con los valores 
de los estadsticos calculados

OPCIONES detrs del DATA:

ALPHA: indica nivel de confianza para intervalos de conf
CLM: intervalo de confianza
MEAN: calcula media
RANGE: max - min
CV: coef. variacin
SKEWNESS: asimetria
KURTOSIS
MAX 
MIN
MODE: moda
VAR: varianza
STD: desv standard
MEDIAN: mediana
SUM; suma
P1, P5.. (percentiles)
Q1, Q3 cuartiles
Por defecto calcula N MEAN STD MIN MAX
MAXDEC numero maximo de decimales para mostrar calculos
PRINTALLTYPES: hace el analisis para los grupos indicados detras de CLASS y tambin para el total de individuos
NOPRINT: no hace la salida de resultados

HYPOTHESIS TESTING KEYWORDS:
T: Prueba T con H0 media = 0
PROBT: P-valor del contraste 

*/

proc means data=sashelp.class;
var height;
run;

proc means data=sashelp.class;
var height;
output out=descrip1;
run;

proc means data=sashelp.class noprint;
var height;
class sex;
output out=descrip2 mean=media q1=cuart1 q3=cuart3 kurt=curt skew=asimet;
run;

proc means data=sashelp.class printalltypes mean median var skew kurt p5 q3;
var height;
CLASS sex;
run;

proc means data=sashelp.class alpha=.1 clm mean maxdec=2;
var height;
run;

proc means data=sashelp.class t probt;
var height;
run;

/*PROC CORR

Matriz de correlaciones y covarianzas, contrasta si los coef. de correl. 
son o no distintos de cero

PROC CORR DATA = Bdd/ [OPCIONES];
VAR NomV1
[CLASS/BY];
[WITH];
RUN;

WITH har el calculo del coef de cada variable que ponemos detras de VAR con la que indicamos detras de WITH

En Opciones podemos indicar
PEARSON: coef correl de Pearson - relacioes lineales
SPEARMAN: correl por rangos de Spearman - noparametrico -relaciones monotonicas
KENDALL: Tau de Kendall (measures the ordinal association between two measured quantities)
COV:  Matriz de covarianzas
OUTP: Crear base de datos con los coeficientes de corr 

*/

proc corr data=sashelp.class;
var height weight age; 
run;

proc corr data=sashelp.class cov outp=corrclass;
var height weight age; 
run;

proc corr data=sashelp.class;
var height weight; 
with age; 
run;

/*PROC UNIVARIATE

Hace un analisis univariante completo

PROC UNIVARIATE DATA = Bdd [OPCIONES];
VAR NomV1 NomV2..;
[HISTOGRAM];
[PROBPLOT/QQPLOT]; Probaility o qq plot para comparar observaciones vs terico
[INSET];
[OUTPUT];
[CLASS];
RUN;

Entre las OPCIONES, tenemos:
ALPHA Nivel de confianza para intervalos
CIBASIC Intervalo de confianza asumiendo normalidad
PLOT Box plot, steam and leaf plots
NORMAL Test de normalidad
MU0 Valor para contrastar H0: mu0=valor

Ademas:

HISTOGRAM Hace histogramas
PROBPLOT 
QQPLOT

*/

libname W 'C:\Users\daniel.fernandez\Dropbox\02.Teaching\04.UB-UPC\CompEstad_Optim\02.Practiques\01.Future\05.SAS-Tema5\dades_s05';

OPTIONS FMTSEARCH=(W);  */ *Indicamos en que libreria buscar por defecto los formatos;


proc contents data=W.MEGAZ; run;


proc univariate data=W.megaz; 
var age; run;

proc univariate data=W.megaz cibasic alpha = 0.1; * mu0=36; 
var age; 
run;

proc univariate data=W.megaz plot normal; 
var age; 
run;

proc univariate data=W.megaz; 
var age income; 
histogram; 
run;

proc univariate data=W.megaz; 
var age; 
probplot/normal(mu=est sigma=est); /*Probability plot which compares 
									ordered variable values with the percentiles 
									of a Normal theoretical distribution.
			                        mu=est sigma=est indica que se calcular los estimadores
									de de la media y la desv standard usando la muestra*/
*qqplot/normal(mu=est sigma=est); 
run;

proc univariate data=W.megaz; 
var age; 
output out=perce p5=p5 p95=p95; /*Guardamos P5 y P95 en la bbd temporal perce */
run;

proc univariate data=W.megaz; 
var age; 
histogram / midpoints=20 to 70 by 5 grid midpercents; 
inset mean='Media' min='Minimo'
      max='Maximo' std = 'Desv. tipica' 
      /header='Estadisticos' position=ne format=5.2;
run;

/* Mirar los resultados en la ventana de Results */
proc univariate data=W.megaz; 
class  dept ;
var gender age ; 
histogram / midpoints=20 to 70 by 5 grid midpercents nrow=2 ncol=1 normal; 
inset mean='Media' min='Minimo'
      max='Maximo' std = 'Desv. tipica' 
      /header='Estadisticos' position=ne format=5.2;
label dept='Dept';
run;


/*PROC TABULATE

Presentacion de resultados, tablas de frecuencias y descriptivos 

PROC TABULATE DATA = Bdd / [OPCIONES];
VAR NomV1 NomV2..;
[CLASS];
TABLES NomV1*NomV2..,...;
RUN;

La lista de variables que ponemos detras de TABLES ha de aparecer en VAR o en CLASS
En TABLES ponemos primero los niveles de las filas, 
y detras de la coma ponemos lo que va en columnas

*/

proc tabulate data=W.megaz; 
class gender store;
var v4;
tables gender*store, v4; /* V4 - es la variable de valoracion de precios */
run;

proc tabulate data=W.megaz out=tabla; 
class gender store;
var v4 v5; /* V5 - Horaris convenientes */
tables gender*store,(v4*mean v5*mean); /* La media en lugar de frecuencias*/
run;

proc tabulate data=W.megaz; 
class gender store;
var v4 v5;
tables gender*store,(v4*mean='Media de V4' v5*mean='Media de V5'); 
run;

proc tabulate data=W.megaz; 
class gender;
var age income;
tables (age*(mean min max std) income*(mean min max std)),gender; 
run;



