# Full "chuleta" de LaTeX per a Principiants

## Introducció

Aquests full "chuleta" està dissenyat per ajudar-te a començar amb LaTeX i la plantilla proporcionada per als teus projectes finals d'estudis a la Facultat de Matemàtiques de la UPC. Cobreix les comandes bàsiques de LaTeX i instruccions específiques per utilitzar aquesta plantilla.

## Comandes Bàsiques de LaTeX

### Comentari

```latex
% %Tot el que va a la dreta del percentatge es un "comentari"
```

### Estructura del Document

```latex
\documentclass{article} % Defineix el tipus de document
\begin{document}        % Comença el contingut del document
\end{document}          % Finalitza el contingut del document
```

### Seccions i subseccions

```latex
\chapter{Title Chapter} % Crear un nou capitol
\label{ch:title-example} % Referent intern del titol (important!)

\section{Section Title} % Crea una nova secció
\label{s:section-example} % Referent intern de la secció (important!)

\subsection{Subsection Title} % Crea una nova subsecció

\subsubsection{Subsubsection Title} % Crea una nova subsubsecció

```

### Text Formatting

```latex
\textbf{Bold Text}       % Text negreta
\textit{Italic Text}     % Text en cursiva
\underline{Underlined Text} % TExt subratllat
```

### Enllaços i Referències

#### Enllaçar a un URL

```latex
\href{https://www.example.com}{Text de l'enllaç}
```

#### Referenciar un Fitxer Local

```latex
\href{run:./path/to/localfile.pdf}{Text del fitxer local}
```

#### Referenciar una Secció del Mateix Document

```latex
Veure la secció \ref{s:seccio-exemple} per a més detalls.
```

### Llistes

#### Llistes sense ordre

```latex
\begin{itemize}
  \item First item
  \item Second item
\end{itemize}
```

#### Llistes ordenades

```latex
\begin{enumerate}
  \item First item
  \item Second item
\end{enumerate}
```

### Taules

```latex
\begin{table}[h]
\centering
\begin{tabular}{|c|c|c|}
\hline
Header1 & Header2 & Header3 \\
\hline
Data1 & Data2 & Data3 \\
Data4 & Data5 & Data6 \\
\hline
\end{tabular}
\caption{Table Caption}
\end{table}
```

### Imatges

```latex
\begin{figure}[h]
\centering
\includegraphics[width=\textwidth]{path/to/image}
\caption{Figure Caption}
\end{figure}
```

### Escriptura de Fórmules Matemàtiques

LaTeX és àmpliament utilitzat per escriure fórmules matemàtiques de manera clara i elegant. Aquí tens alguns exemples bàsics per començar:

#### Fórmules en Línia

Per escriure fórmules dins d'una línia de text, utilitza `$...$`:

```latex
La fórmula de l'àrea d'un cercle és $A = \pi r^2$.
```

#### Fórmules en Bloc

Per escriure fórmules en un bloc separat, utilitza `\[...\]`:

```latex
\[
E = mc^2
\]
```

#### Fraccions

Per escriure fraccions, utilitza `\frac{numerador}{denominador}`:

```latex
\[
\frac{a}{b}
\]
```

#### Índexs i Exponents

Per escriure índexs i exponents, utilitza `_{}` i `^{}` respectivament:

```latex
\[
x_i \quad x^2
\]
```

#### Arrels

Per escriure arrels quadrades i n-èsimes arrels, utilitza `\sqrt{}` i `\sqrt[n]{}` respectivament:

```latex
\[
\sqrt{x} \quad \sqrt[3]{x}
\]
```

#### Sumes i Integrals

Per escriure sumes i integrals, utilitza `\sum` i `\int` respectivament:

```latex
\[
\sum_{i=1}^{n} i \quad \int_{a}^{b} f(x) \, dx
\]
```

Aquestes són només algunes de les moltes capacitats de LaTeX per escriure fórmules matemàtiques. Consulta la documentació de LaTeX per a més detalls i exemples avançats.

### Incloure Llistats

```latex
\lstset{language=Python} % Defineix el llenguatge del llistat
\begin{lstlisting}
# Aquí va el teu codi
print("Hola, món!")
\end{lstlisting}
```

Per incloure llistats de codi en el teu document LaTeX, pots utilitzar el paquet `listings`. Assegura't d'incloure la següent comanda en el preàmbul del teu document:

```latex
\usepackage{listings}
```

### Glossaris

Els glossaris són útils per definir termes tècnics o abreviatures que s'utilitzen en el teu document. Per utilitzar glossaris en LaTeX, necessitaràs el paquet `glossaries`. Afegeix la següent comanda en el preàmbul del teu document:

```latex
\usepackage{glossaries}
\makeglossaries
```

#### Definir Entrades de Glossari

Per definir una entrada de glossari, utilitza la comanda `\newglossaryentry`:

```latex
\newglossaryentry{latex}{
    name={LaTeX},
    description={Un sistema de preparació de documents}
}
```

#### Utilitzar Entrades de Glossari

Per utilitzar una entrada de glossari en el teu document, utilitza la comanda `\gls`:

```latex
El terme \gls{latex} es refereix a un sistema de preparació de documents.
```

#### Generar el Glossari

Per generar el glossari, afegeix la següent comanda on vols que aparegui el glossari en el teu document:

```latex
\printglossaries
```

#### Exemple complet

Aquí tens un exemple complet de com utilitzar glossaris en un document LaTeX:

```latex
\documentclass{article}
\usepackage{glossaries}
\makeglossaries

\newglossaryentry{latex}{
    name={LaTeX},
    description={Un sistema de preparació de documents}
}

\begin{document}

El terme \gls{latex} es refereix a un sistema de preparació de documents.

\printglossaries

\end{document}
```

Aquestes són les passes bàsiques per crear i utilitzar glossaris en LaTeX. Consulta la documentació del paquet `glossaries` per a més opcions i funcionalitats avançades.

## Ús de la Plantilla

### Personalitzar la Plantilla

- **Pàgina de Títol**: Modifica la pàgina de títol editant els camps title, author i altres camps rellevants al fitxer main.tex.
- **Seccions**:Utilitza les seccions predefinides a la plantilla per estructurar el teu document. Afegeix o elimina seccions segons sigui necessari.
- **Bibliografia**: Afegeix les teves referències al fitxer references.bib i cita-les en el teu document utilitzant la comanda \cite{}.

## Recursos Addicionals

- **Overleaf**: Utilitza Overleaf per a un editor de LaTeX en línia amb funcions de col·laboració. La plantilla està disponible  [aquí](https://es.overleaf.com/latex/templates/upm-report-template/sxtmzsytgthp).
- **Documentació de LaTeX**: Consulta el [LaTeX Wikibook](https://en.wikibooks.org/wiki/LaTeX) per a documentació i exemples complets.


## Contacte

Per a qualsevol pregunta o suggeriment sobre aquesta plantilla, si us plau contacta amb el mantenidor.