# fme-tfe-plantilla

## Objectiu

Tenir unes plantilles LaTeX per a les memòries dels treballs finals d'estudis (tant per TFGs com TFMs) de la Facultat de Matemàtiques de la UPC. Llegiu `report.pdf` per tal de tenir una idea de l'aspecte de la memòria i com a guia d'utilització.

## Descripció

La memòria és un component essencial en la presentació dels treballs. Aquesta plantilla proporciona una estructura i format predefinits que faciliten la creació i presentació de la memòria.

### Característiques

- Estructura clara i coherent per a una memòria acadèmica.
- Disseny professional i agradable a la vista.
- Portada i contraportada personalitzables amb el logotip de la UPC i altres detalls com la facultat.
- Seccions predefinides per a resum, introducció, objectius, metodologia, resultats, conclusions, referències, etc.
- Citacions i referències bibliogràfiques en format adequat.
- Plantilles de quadres i figures per facilitar la presentació de dades.
- Utilitza el format LaTeX per garantir la qualitat tipogràfica i la facilitat d'edició.

## Ús des d'Overleaf (Online)

Per tenir accés complet a Overleaf (funcions premium), caldrà que l'alumne descarregui la plantilla i l'envii al seu tutor. Aquest haurà de crear el projecte a l'Overleaf (programa que el PDI de la UPC te accés a totes les funcions) i compartir-lo amb l'alumne que tutoritza el TFE. Així l'alumne podrà gaudir de també de totes les funcions premium.

## Ús en local

Per utilitzar la plantilla en local, segueix aquests passos:

1. Descarrega el repositori al teu ordinador.
2. Obre el projecte amb el teu editor de text compatible amb LaTeX (ej. Texworks).
3. Compila el document utilitzant XeLaTeX.

## Requisits

Per utilitzar aquesta plantilla, és necessari:

- Un sistema de composició de documents LaTeX instal·lat a l'ordinador.
- L'interpret Perl accesible per el sistema LaTeX.
- Suport de XeLaTeX.
- Familiaritat bàsica amb LaTeX i el seu funcionament.
- Editor de text compatible amb LaTeX (per exemple, TeXstudio, Texmaker, etc.).

Aquest requeriments estan definits amb mes detall al `report.pdf`.

## Compilació Ràpida

Es recomana fer servir les configuracions de Visual Studio Code ofertes al `report.pdf`.

En cas de voler fer servir sistema alternatiu al proposat, hi ha un document Makefile en el repositori que permet compilar fàcilment el PDF. Per compilar fent ús d'aquest, executa `make` amb el target `unix` o `win` depenent del sistema operatiu.

## Llicència

Aquesta plantilla es distribueix sota la llicència Creative Commons 4.0 BY-NC-SA. Pots utilitzar-la, modificar-la i compartir els teus canvis sempre que es respectin els termes de la llicència.

## Contacte

Si tens alguna pregunta o suggerència sobre aquesta plantilla, no dubtis en posar-te en contacte amb la biblioteca FME.
